/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.datagen.ModBlockModelProvider;
import com.voxelutopia.ultramarine.datagen.ModBlockTagProvider;
import com.voxelutopia.ultramarine.datagen.ModItemModelProvider;
import com.voxelutopia.ultramarine.datagen.ModItemTagProvider;
import com.voxelutopia.ultramarine.datagen.ModLootTableProvider;
import com.voxelutopia.ultramarine.datagen.ModRecipeProvider;
import com.voxelutopia.ultramarine.mixin.RegistriesDatapackGeneratorAccessor;
import com.voxelutopia.ultramarine.world.feature.ModConfiguredFeatures;
import com.voxelutopia.ultramarine.world.feature.ModPlacedFeatures;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ultramarine", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    public static final String MOD_ID = "ultramarine";
    public static final RegistrySetBuilder DATA_BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ModConfiguredFeatures::createConfiguredFeatures).m_254916_(Registries.f_256988_, ModPlacedFeatures::createPlacedFeatures);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fh = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(output, (CompletableFuture)lookupProvider, DATA_BUILDER, Set.of(MOD_ID));
        lookupProvider = ((RegistriesDatapackGeneratorAccessor)provider).getRegistries();
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        ModBlockTagProvider blockTags = new ModBlockTagProvider(output, lookupProvider, fh);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(output, lookupProvider, (TagsProvider<Block>)blockTags, fh));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(generator));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockModelProvider(output, fh));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, fh));
    }
}

